FUNCTION_BLOCK PMC_ReadXbotPos
	IF Enable = TRUE THEN
		(* Statement section IF*)
		(*read xbot ID*)
		memcpy(pDest := ADR(curXID),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET,length := 1);
		IF curXID = XbotID THEN
			(* Statement section IF*)
			(*read X position from frame*)
			memcpy(pDest := ADR(PosX ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 4,length := 4);
			PMCDB_pointer.PosX[XbotID - 1] := PosX;
	        
			(*read Y position from frame*)
			memcpy(pDest := ADR(PosY ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 8,length := 4);
			PMCDB_pointer.PosY[XbotID - 1] := PosY;
	        
			(*read Z position from frame*)
			memcpy(pDest := ADR(PosZ ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 12,length := 4);
			PMCDB_pointer.PosZ[XbotID - 1] := PosZ;
	        
			(*read RX position from frame*)
			memcpy(pDest := ADR(PosRx ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 16,length := 4);
			PMCDB_pointer.PosRx[XbotID - 1] := PosRx;
	        
			(*read RY position from frame*)
			memcpy(pDest := ADR(PosRy ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 20,length := 4);
			PMCDB_pointer.PosRy[XbotID - 1] := PosRy;
	        
			(*read RZ position from frame*)
			memcpy(pDest := ADR(PosRz ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 24,length := 4);
			PMCDB_pointer.PosRz[XbotID - 1] := PosRz;
	        
			Valid := TRUE;
		ELSE
			PosX := PMCDB_pointer.PosX[XbotID - 1];
			PosY := PMCDB_pointer.PosY[XbotID - 1];
			PosZ := PMCDB_pointer.PosZ[XbotID - 1];
			PosRx := PMCDB_pointer.PosRx[XbotID - 1];
			PosRy := PMCDB_pointer.PosRy[XbotID - 1];
			PosRz := PMCDB_pointer.PosRz[XbotID - 1];
	        
			IF curXID > 0 AND curXID <= 256 THEN
				(*Update whatever xbot is on the fieldbus*)
				(*read X position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosX[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 4,length := 4);
	            
				(*read Y position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosY[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 8,length := 4);
	            
				(*read Z position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosZ[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 12,length := 4);
	            
				(*read RX position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosRx[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 16,length := 4);
	            
				(*read RY position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosRy[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 20,length := 4);
	            
				(*read RZ position from frame*)
				memcpy(pDest := ADR(PMCDB_pointer.PosRz[curXID - 1] ),pSrc := ADR(FBin_pointer) + P2H_START + P2H_MUX_OFFSET + 24,length := 4);
			END_IF;
	        
			Valid := FALSE;
		END_IF;
	    
	ELSE
		Valid := FALSE;
	END_IF;
END_FUNCTION_BLOCK
